#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
using namespace std;

// Loops
#define FOR(n)              for(int i=0;i<n;i++)
#define FORJ(n)             for(int j=0;j<n;j++)
#define FORN(n,x)           for(int x=0;i<n;i++)
#define RFOR(n)             for(int i=n-1;i>=0;i--)
#define RFORN(n,x)          for(int x=n-1;x>=0;x--)
#define ODD_FOR(n)          for(int i=1;i<n;i+=2)
#define EVEN_FOR(n)         for(int i=2;i<n;i+=2)
#define FROM(n,m)           for(int i=n;i<m;i++)
#define FROMJ(n,m)          for(int j=n;j<m;j++)
#define RFROM(n,m)          for(int i=n-1;i>=m;i--)
#define RFROMJ(n,m)         for(int j=n-1;j>=m;j--)
#define STL_FOR(a)          for(auto i=a.begin();i!=a.end();i++)
#define STL_FORJ(a)         for(auto j=a.begin();j!=a.end();j++)
#define STL_FORN(a,x)       for(auto x=a.begin();x!=a.end();x++)
#define STL_FROM(a,n,m)     for(auto i=n;i!=m;i++)
#define STL_FROMJ(n,m)      for(auto j=n;j!=m;j++)
#define RSTL_FOR(a)         for(auto i=a.rbegin();i!=a.rend();i++)
#define RSTL_FORJ(a)        for(auto j=a.rbegin();j!=a.rend();j++)

// Types
#define ll             long long int
#define vec                   vector
#define veci             vector<int>
#define pb                 push_back
#define pf                push_front
#define fi                     first
#define se                    second
#define umap           unordered_map
#define ummap     unordered_multimap
#define mmap                multimap
#define mset                multiset
#define uset           unordered_set
#define umset     unordered_multiset
#define endl                    '\n'
#define all(a)    a.begin(), a.end()

// I/O
void read() {}
template<typename type, typename... types>
void read(type& arg, types&... args) { cin >> arg; read(args...); }

void write() { cout << endl; }
template<typename type, typename... types>
void write(type arg, types... args) { cout << arg << ' '; write(args...); }

#define dbg(x) cerr<<#x<<" = "<<x<<endl;

struct edgedist {
    int e, d;
};

struct graph {
    int n, m;
    list<int>* adj;

    graph(int n, int m) :
        n(n), m(m)
    {
        adj = new list<int>[n + 1];
    }
    //~graph() {delete[] adj;}

    void add_edge(int node, int edge) {
        adj[node].push_back(edge);
        adj[edge].push_back(node);
    }

    friend istream& operator>> (istream& in, graph& g) {
        int node, edge;
        for (int i = 0; i < g.m; i++) {
            in >> node >> edge;
            g.add_edge(node, edge);
        }
        return in;
    }
};


int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    ll n, m, k, l;
    cin >> n >> m >> k >> l;

    vector<ll> a(n*m);
    FOR(n * m) cin >> a[i];
    sort(a.begin(), a.end());

    ll small_n = min(k, n - k + 1);
    ll rep_n = n - 2 * (small_n - 1);

    ll small_m = min(l, m - l + 1);
    ll rep_m = m - 2 * (small_m - 1);

    vector<ll> rep(small_n*small_m+1, 0);
    
    FROM(1, small_n + 1) {
        FROMJ(1, small_m + 1) {
            if (i == small_n && j == small_m) {
                rep[i * j] += rep_n * rep_m;
            }
            else if (i == small_n) {
                rep[i * j] += rep_n*2;
            }
            else if (j == small_m) {
                rep[i * j] += rep_m*2;
            }
            else rep[i * j] += 4;
        }
    }

    ll ans = 0;
    ll indx = 0;
    FROM(1, small_n* small_m + 1) {
        if (rep[i] != 0) {
            //cout << i << " : " << rep[i] << endl;
            FORJ(rep[i]) {
                //cout << i << " * " << a[indx] << endl;
                ans += (ll)i * a[indx++];
            }
        }
    }
    cout << ans << endl;
}

/*
9  9 4 3

1  2  3  3  3  3  3  2  1
2  4  6  6  6  6  6  4  2
3  6  9  9  9  9  9  6  3
4  8 12 12 12 12 12  8  4
4  8 12 12 12 12 12  8  4
4  8 12 12 12 12 12  8  4
3  6  9  9  9  9  9  6  3
2  4  6  6  6  6  6  4  2
1  2  3  3  3  3  3  2  1

1  2  3
2  4  6
3  6  9
4  8 12



1  2  3  4  5  4  3  2 1
2  4  6  8 10  8  6  4 2
3  6  9 12 15 12  9  6 3
4  8 12 16 20 16 12  8 4
5 10 15 20 25 20 15 10 5
4  8 12 16 20 16 12  8 4
3  6  9 12 15 12  9  6 3
2  4  6  8 10  8  6  4 2
1  2  3  4  5  4  3  2 1


1  2  3  4  5
2  4  6  8 10
3  6  9 12 15
4  8 12 16 20
5 10 15 20 25


12 12 6 6
1  2  3  4  5  6  6  5  4  3  2  1
2  4  6  8 10 12 12 10  8  6  4  2
3  6  9 12 15 18 18 15 12  9  6  3
4  8 12 16 20 24 24 20 16 12  8  4
5 10 15 20 25 30 30 25 20 15 10  5
6 12 18 24 30 36 36 30 24 18 12  6
6 12 18 24 30 36 36 30 24 18 12  6
5 10 15 20 25 30 30 25 20 15 10  5
4  8 12 16 20 24 24 20 16 12  8  4
3  6  9 12 15 18 18 15 12  9  6  3
2  4  6  8 10 12 12 10  8  6  4  2
1  2  3  4  5  6  6  5  4  3  2  1




*/